	include	defs.asm

;  Copyright, 1988, 1989, Russell Nelson

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

code	segment byte public
	assume	cs:code, ds:code

	public	phd_environ
	org	2ch
phd_environ	dw	?

	public	phd_dioa
	org	80h
phd_dioa	label	byte

	org	100h
start:
	jmp	start_1
	extrn	start_1: near

;we use our dioa for a stack space.  Very hard usage has shown that only
;  27 bytes were being used, so 128 should be sufficient.
our_stack	label	byte


	extrn	int_no: byte
	public	packet_int_no, is_at, sys_features
packet_int_no	db	?,?,?,?		; interrupt to communicate.
is_at		db	0		; =1 if we're on an AT.
sys_features	db	0		; 2h = MC   40h = 2nd 8259

functions	label	word
	dw	f_driver_info		;function 1
	dw	f_access_type
	dw	f_release_type
	dw	f_send_pkt
	dw	f_terminate
	dw	f_get_address
	dw	f_reset_interface	;function 7
	dw	f_set_rcv_mode		;function 20
	dw	f_get_rcv_mode
	dw	f_set_multicast_list
	dw	f_get_multicast_list
	dw	f_get_statistics
	dw	f_set_address		;function 25


	extrn	driver_class: byte
	extrn	driver_type: byte
	extrn	driver_name: byte

	extrn	send_pkt: near
	extrn	get_address: near
	extrn	set_address: near
	extrn	reset_interface: near
	extrn	recv: near
	extrn	recv_exiting: near

	extrn	rcv_modes: word		;count of modes followed by mode handles.

	extrn	set_multicast_list: near
	extrn	get_multicast_list: near

per_handle	struc
in_use		db	?		;non-zero if this handle is in use.
packet_type	db	MAX_P_LEN dup(?);associated packet type.
packet_type_len	dw	?		;associated packet type length.
receiver	dd	?		;receiver handler.
		db	?		;padding to get the length to 16.
per_handle	ends

  if (size per_handle) NE 16
	err	The size of the handle must be 16.
  endif

handles		db	MAX_HANDLE*(size per_handle) dup(0)
end_handles	label	byte

multicast_count	dw	0		;count of stored multicast addresses.
multicast_addrs	db	MAX_MULTICAST*EADDR_LEN dup(?)

have_my_address	db	0		;nonzero if our address has been set.
my_address	db	MAX_ADDR_LEN dup(?)
my_address_len	dw	?

rcv_mode_num	dw	3

free_handle	dw	?		;->a handle not in use.
found_handle	dw	?		;->the handle for our packet.
receive_ptr	dd	?		;->the receive routine.

savess		dw	?		;saved during the stack swap.
savesp		dw	?

regs	struc
_ES	dw	?
_DS	dw	?
_BP	dw	?
_DI	dw	?
_SI	dw	?
_DX	dw	?
_CX	dw	?
_BX	dw	?
_AX	dw	?
_IP	dw	?
_CS	dw	?
_F	dw	?		;flags
regs	ends

CY	equ	0001h
EI	equ	0200h


bytes	struc
	dw	?
	dw	?
	dw	?
	dw	?
	dw	?
_DL	db	?
_DH	db	?
_CL	db	?
_CH	db	?
_BL	db	?
_BH	db	?
_AL	db	?
_AH	db	?
bytes	ends

	public	our_isr, their_isr
their_isr	dd	?

our_isr:
	jmp	our_isr_0		;the required signature.
	db	'PKT DRVR',0

statistics_list	label	dword
packets_in	dw	?,?
packets_out	dw	?,?
bytes_in	dw	?,?
bytes_out	dw	?,?
errors_in	dw	?,?
errors_out	dw	?,?
packets_dropped	dw	?,?		;dropped due to no type handler.

linc	macro	n
	local	a
	inc	n			;increment the low word
	jne	a			;go if not overflow
	inc	n+2			;increment the high word
a:
	endm

	public	count_in_err
count_in_err:
	assume	ds:nothing
	linc	errors_in
	ret

	public	count_out_err
count_out_err:
	assume	ds:nothing
	linc	errors_out
	ret

our_isr_0:
	assume	ds:nothing
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	cld
	mov	bx,cs			;set up ds.
	mov	ds,bx
	assume	ds:code
	mov	bp,sp			;we use bp to access the original regs.
	and	_F[bp],not CY		;start by clearing the carry flag.
	test	_F[bp],EI		;were interrupts enabled?
	jz	our_isr_ei		;no.
;	sti				;yes - re-enable them.
our_isr_ei:
	mov	dh,BAD_COMMAND		;in case we find a bad number.
	mov	bl,ah			;jump to the correct function.
	mov	bh,0
	cmp	bx,7			;highest function is 7.
	jbe	our_isr_ok
	cmp	bx,20
	jb	our_isr_error
	cmp	bx,25
	ja	our_isr_error
	sub	bx,20-7-1		;map 20 right after 7.
our_isr_ok:
	add	bx,bx			;*2
	call	functions-2[bx]		;table starts at 1.
	jnc	our_isr_return
our_isr_error:
	mov	_DH[bp],dh
	or	_F[bp],CY		;return their carry flag.
our_isr_return:
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret


f_driver_info:
;	Under 1.08, the handle is optional, so we no longer verify it.
;	call	verify_handle
	mov	_BX[bp],majver		;version
	mov	al,driver_class
	mov	_CH[bp],al
	mov	al,driver_type
	cbw
	mov	_DX[bp],ax
	mov	_CL[bp],0		;number zero.
	mov	_DS[bp],ds
	mov	_SI[bp],offset driver_name
	mov	_AL[bp],2		;extended driver
	clc
	ret


f_set_rcv_mode:
	call	verify_handle
	mov	cx,_CX[bp]		;Tell them how much room they have.
	cmp	cx,rcv_modes		;do they have this many modes?
	jae	f_set_rcv_mode_1	;no - must be a bad mode for us.
	mov	bx,cx
	add	bx,bx			;we're accessing words, not bytes.
	mov	ax,rcv_modes[bx]+2	;get the handler for this mode.
	or	ax,ax			;do they have one?
	je	f_set_rcv_mode_1	;no - must be a bad mode for us.
	mov	rcv_mode_num,cx		;yes - remember the number and
	call	ax			;  call it.
	clc
	ret
f_set_rcv_mode_1:
	mov	dh,BAD_MODE
	stc
	ret


f_get_rcv_mode:
	call	verify_handle
	mov	ax,rcv_mode_num		;return the current receive mode.
	mov	_AX[bp],ax
	clc
	ret


f_set_multicast_list:
;	mov	cx,_CX[bp]		;Tell them how much room they have.

;verify that they supplied an even number of EADDR's.
	mov	ax,cx
	xor	dx,dx
	mov	bx,EADDR_LEN
	div	bx
	or	dx,dx			;zero remainder?
	jne	f_set_multicast_list_2

	cmp	cx,MAX_MULTICAST*EADDR_LEN	;is this too many?
	jbe	f_set_multicast_list_1
	mov	cx,MAX_MULTICAST*EADDR_LEN	;yes - store only this many.
f_set_multicast_list_1:
	mov	multicast_count,cx
	push	cs
	pop	es
	mov	di,offset multicast_addrs
	push	ds
	mov	ds,_ES[bp]		; get ds:si -> new list.
	mov	si,_DI[bp]
	rep	movsb
	pop	ds

	mov	es,_ES[bp]		; get new ones
	mov	di,_DI[bp]		; get pointer, es:di is ready
	mov	cx,_CX[bp]		;Tell them how much room they have.
	call	set_multicast_list
	ret
f_set_multicast_list_2:
	mov	dh,BAD_ADDRESS
	stc
	ret


f_get_multicast_list:
	call	get_multicast_list	;Can they do it themselves?
	jnc	f_get_multicast_list_1	;yes - we're all set.
	cmp	dh,NO_ERROR		;do they implement multicast at all?
	stc
	jne	f_get_multicast_list_1	;no - return an error.
	mov	_ES[bp],ds		;we have to return what we have stored.
	mov	_DI[bp],offset multicast_addrs
	mov	cx,multicast_count
	mov	_CX[bp],cx
	clc
f_get_multicast_list_1:
	ret


f_get_statistics:
	call	verify_handle		;just in case.
	mov	_DS[bp],ds
	mov	_SI[bp],offset statistics_list
	clc
	ret


access_type_class:
	mov	dh,NO_CLASS
	stc
	ret

access_type_type:
	mov	dh,NO_TYPE
	stc
	ret

access_type_number:
	mov	dh,NO_NUMBER
	stc
	ret

access_type_bad:
	mov	dh,BAD_TYPE
	stc
	ret

access_type_space:
	mov	dh,NO_SPACE
	stc
	ret

f_access_type:
	mov	al,driver_class
	cmp	_AL[bp],al		;our class?
	jne	access_type_class	;no.
	cmp	_BX[bp],-1		;generic type?
	je	access_type_2		;yes.
	mov	al,driver_type
	cbw
	cmp	_BX[bp],ax		;our type?
	jne	access_type_type	;no.
access_type_2:
	cmp	_DL[bp],0		;generic number?
	je	access_type_3
	cmp	_DL[bp],1		;our number?
	jne	access_type_number
access_type_3:
	cmp	_CX[bp],MAX_P_LEN	;is the type length too long?
	ja	access_type_bad		;yes - can't be ours.
access_type_7:

; now we do two things--look for an open handle, and check the existing
; handles to see if they're replicating a packet type.

	mov	free_handle,0		;remember no free handle yet.
	mov	bx,offset handles
access_type_4:
	cmp	[bx].in_use,0		;is this handle in use?
	je	access_type_5		;no - don't check the type.
	mov	es,_DS[bp]		;get a pointer to their type.
	mov	di,_SI[bp]
	mov	cx,_CX[bp]		;get the minimum of their length
					;  and our length.  As currently
					;  implemented, only one receiver
					;  gets the packets, so we have to
					;  ensure that the shortest prefix
					;  is unique.
	cmp	cx,[bx].packet_type_len	;Are we less specific than they are?
	jb	access_type_8		;no.
	mov	cx,[bx].packet_type_len	;yes - use their count.
access_type_8:
	lea	si,[bx].packet_type
	or	cx,cx			;in case cx is zero.
	repe	cmpsb
	jne	short access_type_6	;go look at the next one.
access_type_inuse:
	mov	dh,TYPE_INUSE
	stc
	ret
access_type_5:
	cmp	free_handle,0		;found a free handle yet?
	jne	access_type_6		;yes.
	mov	free_handle,bx		;remember a free handle
access_type_6:
	add	bx,(size per_handle)	;go to the next handle.
	cmp	bx,offset end_handles
	jb	access_type_4

	mov	bx,free_handle		;did we find a free handle?
	or	bx,bx
	je	access_type_space	;no - return error.

	mov	[bx].in_use,1		;remember that we're using it.

	mov	ax,_DI[bp]		;remember the receiver type.
	mov	[bx].receiver.offs,ax
	mov	ax,_ES[bp]
	mov	[bx].receiver.segm,ax

	push	ds
	mov	ax,ds
	mov	es,ax
	mov	ds,_DS[bp]		;remember their type.
	mov	si,_SI[bp]
	mov	cx,_CX[bp]
	mov	es:[bx].packet_type_len,cx	;remember the length.
	lea	di,[bx].packet_type
	rep	movsb
	pop	ds

	sub	bx,offset handles	;compute the handle from the offset.
	mov	cl,4
	shr	bx,cl
	mov	ax,cs			;add our phd in.
	add	bx,ax
	mov	_AX[bp],bx		;return the handle to them.

	clc
	ret


f_release_type:
	call	verify_handle		;mark this handle as being unused.
	mov	[bx].in_use,0
	clc
	ret


f_send_pkt:
	linc	packets_out
	add	bytes_out.offs,cx	;add up the received bytes.
	adc	bytes_out.segm,0

	push	ds		; set up proper ds for the buffer
	mov	ds,_DS[bp]	; address for buffer
;following two instructions not needed because si and cx haven't been changed.
;	mov	si,_SI[bp]
;	mov	cx,_CX[bp]	; count of bytes

	call	send_pkt
	pop	ds
	ret


f_terminate:
;
; Now disable interrupts
;
	mov	al,int_no
	call	maskint

;
; Now return the interrupt to their handler.
;
	mov	ah,25h			;get the old interrupt into es:bx
	mov	al,int_no
	add	al,8
	cmp	al,8+8			;is it a slave 8259 interrupt?
	jb	terminate_1		;no.
	add	al,70h - (8+8)		;map it to the real interrupt.
terminate_1:
	push	ds
	lds	dx,their_recv_isr
	int	21h
	pop	ds

	mov	al,packet_int_no	;release our_isr.
	mov	ah,25h
	push	ds
	lds	dx,their_isr
	int	21h
	pop	ds

;
; Now free our memory
;
	push	cs
	pop	es
	mov	ah,49h
	int	21h

	clc
	ret


f_get_address:
	call	verify_handle
;	mov	es,_ES[bp]		; get new one
;	mov	di,_DI[bp]		; get pointer, es:di is ready
	mov	cx,_CX[bp]		;Tell them how much room they have.
	cmp	have_my_address,0	;Did we get our address set?
	jne	get_address_set
	call	get_address
	jc	get_address_space	;no.
	mov	_CX[bp],cx		;Tell them how long our address is.
	clc
	ret
get_address_set:
	cmp	cx,my_address_len	;is there enough room?
	jb	get_address_space	;no.
	mov	cx,my_address_len	;yes - get our address length.
	mov	_CX[bp],cx		;Tell them how long our address is.
	mov	si,offset my_address	;copy it into their area.
	rep	movsb
	clc
	ret

get_address_space:
	mov	dh,NO_SPACE
	stc
	ret


f_set_address:
	mov	bx,offset handles
	mov	dh,CANT_SET		;if a handle in use, we can't set it.
f_set_address_1:
	cmp	[bx].in_use,0		;is this handle in use?
	stc
	jne	f_set_address_exit	;yes - we can't set the address
	add	bx,(size per_handle)	;go to the next handle.
	cmp	bx,offset end_handles
	jb	f_set_address_1

	mov	ds,_ES[bp]		; set new one
	assume	ds:nothing
	mov	si,_DI[bp]		; set pointer, ds:si is ready
;	mov	cx,_CX[bp]		;Tell them how much address is being set.
	call	set_address
;set_address restores ds.
	jc	f_set_address_exit	;Did it work?
	mov	_CX[bp],cx		;yes - return our address length.

	cmp	cx,MAX_ADDR_LEN		;is it too long for us to remember?
	ja	f_set_address_too_long	;yes, return a too-long error.

	mov	ds,_ES[bp]		; set new one
	mov	si,_DI[bp]		; set pointer, ds:si is ready
	mov	ax,cs
	mov	es,ax
	mov	my_address_len,cx	;remember how long our address is.
	mov	di,offset my_address
	rep	movsb
	mov	have_my_address,1
	mov	ds,ax			;restoer ds.
	assume	ds:code
	clc
	jmp	short f_set_address_exit

f_set_address_too_long:
	mov	dh,NO_SPACE
	stc
f_set_address_exit:
	ret


f_reset_interface:
	call	verify_handle
	call	reset_interface
	clc
	ret


compute_handle:
;enter with the external representation of our handle in _BX[bp],
;exit with the offset of the handle in bx.
	mov	bx,_BX[bp]		;get the handle they gave us
	mov	cx,cs
	sub	bx,cx			;subtract off our phd
	mov	cl,4
	shl	bx,cl			;multiply by the size of the struct,
	add	bx,offset handles	;  and add the offset of the table.
	ret


verify_handle:
;Ensure that their handle is real.  If it isn't, we pop off our return
;address, and return to *their* return address with cy set.
	call	compute_handle
	cmp	bx,offset handles
	jb	verify_handle_bad	;no - must be bad.
	cmp	bx,offset end_handles
	jae	verify_handle_bad	;no - must be bad.
	cmp	[bx].in_use,0		;if it's not in use, it's bad.
	je	verify_handle_bad
	ret
verify_handle_bad:
	mov	dh,BAD_HANDLE
	add	sp,2			;pop off our return address.
	stc
	ret


	public	set_recv_isr
set_recv_isr:
	mov	ah,35h			;get the old interrupt into es:bx
	mov	al,int_no
	add	al,8
	cmp	al,8+8			;is it a slave 8259 interrupt?
	jb	set_recv_isr_1		;no.
	add	al,70h - 8 - 8		;map it to the real interrupt.
set_recv_isr_1:
	int	21h
	mov	their_recv_isr.offs,bx
	mov	their_recv_isr.segm,es

	mov	ah,25h			;now set our recv interrupt.
	mov	dx,offset recv_isr
	int	21h
;
; Now enable interrupts
;
	mov	al,int_no
	call	unmaskint

	ret

their_recv_isr	dd	?

recv_isr:
	push	ax
	push	ds
	mov	ax,cs			;ds = cs.
	mov	ds,ax

	mov	savesp,sp
	mov	savess,ss

	mov	ss,ax
	mov	sp,offset our_stack
	cld
	sti

	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	es

	call	recv

	cli				;interrupts *must* be off between
					;here and the stack restore, because
					;if we have one of our interrupts
					;pending, we would trash our stack.
;
; The following code is ruthlessly stolen from Phil Karn's NET package.
;
	test	sys_features,40h ; 2nd 8259 installed?
	jz	recv_isr_3	; Only one 8259, so skip this stuff
	mov	al,0bh		; read in-service register from
	out	0a0h,al		; secondary 8259
	nop			; settling delay
	nop
	nop
	in	al,0a0h		; get it
	or	al,al		; Any bits set?
	jz	recv_isr_3	; nope, not a secondary interrupt
	mov	al,20h		; Get EOI instruction
	out	0a0h,al		; Secondary 8259 (PC/AT only)
recv_isr_3:
	mov	al,20h			;acknowledge the interrupt.
	out	20h,al

	pop	es
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx

	mov	ss,savess
	mov	sp,savesp

	call	recv_exiting		;this routine can enable interrupts.

	pop	ds
	pop	ax
	iret


maskint:
	mov	dx,21h			;assume the master 8259.
	cmp	al,8			;using the slave 8259 on an AT?
	jb	mask_not_irq2
	mov	dx,0a1h			;go enable it on slave 8259
	sub	al,8
mask_not_irq2:
	mov	cl,al

	in	al,dx			;enable interrupts on the correct 8259.
	mov	ah,1			;set the bit.
	shl	ah,cl
	or	al,ah
	out	dx,al

	ret


unmaskint:
	mov	dx,21h			;assume the master 8259.
	cmp	al,8			;using the slave 8259 on an AT?
	jb	unmask_not_irq2
	mov	dx,0a1h			;go enable it on slave 8259
	sub	al,8
unmask_not_irq2:
	mov	cl,al

	in	al,dx			;enable interrupts on the correct 8259.
	mov	ah,1			;clear the bit.
	shl	ah,cl
	not	ah
	and	al,ah
	out	dx,al

	ret


	public	recv_find
recv_find:
;called when we want to determine what to do with a received packet.
;enter with cx = packet length, es:di -> packet type.
	assume	ds:code, es:nothing
	push	cx

	mov	bx,offset handles
recv_find_1:
	cmp	[bx].in_use,0		;is this handle in use?
	je	recv_find_2		;no - don't check the type.
	mov	ax,[bx].receiver.offs	;do they have a receiver?
	or	ax,[bx].receiver.segm
	je	recv_find_2		;no - they're not serious about it.
	mov	cx,[bx].packet_type_len	;compare the packets.
	lea	si,[bx].packet_type
	or	cx,cx			;in case cx is zero.
	push	di
	repe	cmpsb
	pop	di
	je	recv_find_3		;we've got it!
recv_find_2:
	add	bx,(size per_handle)	;go to the next handle.
	cmp	bx,offset end_handles
	jb	recv_find_1

	linc	packets_dropped

	pop	cx			;we didn't find it -- discard it.
	xor	di,di			;"return" a null pointer.
	mov	es,di
	jmp	short recv_find_4
recv_find_3:
	pop	cx			; the packet_length

	linc	packets_in
	add	bytes_in.offs,cx	;add up the received bytes.
	adc	bytes_in.segm,0

	mov	ax,[bx].receiver.offs
	mov	receive_ptr.offs,ax
	mov	ax,[bx].receiver.segm
	mov	receive_ptr.segm,ax

	sub	bx,offset handles	;compute the handle number from
	shr	bx,1			;  the handle offset.
	shr	bx,1
	shr	bx,1
	shr	bx,1
	mov	ax,cs			;add our phd in.
	add	bx,ax

	mov	found_handle,bx		;remember what our handle was.
	mov	ax,0			;allocate request.
	call	receive_ptr		;ask the client for a buffer.
recv_find_4:
	ret


	public	recv_copy
recv_copy:
;called after we have copied the packet into the buffer.
;enter with ds:si ->the packet, cx = length of the packet.
	assume	ds:nothing, es:nothing
	push	bx
	mov	bx,found_handle
	mov	ax,1			;store request.
	call	receive_ptr		;ask the client for a buffer.
	pop	bx
	ret

code	ends

	end	start
